﻿using System.Drawing;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Controls.Primitives;
using System.Windows.Documents;
using System.Windows.Media;

namespace AZVIC.Ei8htPOS.POSRetail.Helpers
{
    public static class PrintReportHelper
    {
        static System.Windows.Controls.DataGrid _dGrid;

        public static void Print(System.Windows.Controls.DataGrid dGrid, string title)
        {
            FlowDocument document = new FlowDocument();

            document.PageHeight = 850;
            document.PageWidth = 750;
            document.PagePadding = new Thickness(100, 20, 20, 20);

            Table HeaderTable = new Table();
            HeaderTable.Columns.Add(new TableColumn());

            TableRow imgRow = new TableRow();

            imgRow.Cells.Add(new TableCell());
            imgRow.Cells[0].TextAlignment = TextAlignment.Center;
            imgRow.Cells.Add(new TableCell(new Paragraph(new Run(title))));

            HeaderTable.RowGroups.Add(new TableRowGroup());
            HeaderTable.RowGroups[0].Rows.Add(imgRow);

            document.Blocks.Add(HeaderTable);


            Table ItemDetails = new Table();
            for (int i = 0; i < dGrid.Columns.Count; i++)
            {
                if (dGrid.Columns[0].Visibility == Visibility.Visible)
                    ItemDetails.Columns.Add(new TableColumn());
            }
            TableRow HeaderRow;
            DataGridCell dgCell;
            DataGridRow dgRow;
            HeaderRow = new TableRow();
            for (int columnCount = 0; columnCount < dGrid.Columns.Count; columnCount++)
            {
                HeaderRow.Cells.Add(new TableCell(new Paragraph(new Run(dGrid.Columns[columnCount].Header.ToString()))));
            }

            ItemDetails.RowGroups.Add(new TableRowGroup());
            ItemDetails.RowGroups[0].Rows.Add(HeaderRow);

            TableRow detailsRow;
            string val = "";
            for (int rowCount = 0; rowCount < dGrid.Items.Count; rowCount++)
            {
                detailsRow = new TableRow();
                dgRow = GetRow(dGrid, rowCount);
                for (int columnCount = 0; columnCount < dGrid.Columns.Count; columnCount++)
                {
                    dgCell = GetCell(dGrid,rowCount,columnCount);
                    if (dgCell != null && dgCell.IsVisible)
                    {
                        TextBlock tbk = dgCell.Content as TextBlock;
                        if (tbk != null)
                        {
                            val = tbk.Text;
                        }
                        switch(dgCell.Content.GetType().ToString()){
                            case "TextBlock":

                            break;
                        }

                        detailsRow.Cells.Add(new TableCell(new Paragraph(new Run(val))));
                        //val = detailsRow.
                    }
                    else
                        detailsRow.Cells.Add(new TableCell(new Paragraph(new Run(""))));
                }
                ItemDetails.RowGroups[0].Rows.Add(detailsRow);

            }
            document.Blocks.Add(ItemDetails);
            PrintDialog pd = new PrintDialog();
            IDocumentPaginatorSource idocument = document as IDocumentPaginatorSource;
            pd.PrintDocument(idocument.DocumentPaginator, "Report Printing");


        }

        static public DataGridCell GetCell(DataGrid dg, int row, int column)
        {
            DataGridRow rowContainer = GetRow(dg, row);

            if (rowContainer != null)
            {
                DataGridCellsPresenter presenter = GetVisualChild<DataGridCellsPresenter>(rowContainer);
                if (presenter != null)
                {
                    // try to get the cell but it may possibly be virtualized
                    DataGridCell cell = (DataGridCell)presenter.ItemContainerGenerator.ContainerFromIndex(column);
                    if (cell == null)
                    {
                        // now try to bring into view and retreive the cell
                        dg.ScrollIntoView(rowContainer, dg.Columns[column]);
                        cell = (DataGridCell)presenter.ItemContainerGenerator.ContainerFromIndex(column);
                    }

                    return cell;
                }
            }
            return null;
        }

        static public DataGridRow GetRow(DataGrid dg, int index)
        {
            DataGridRow row = (DataGridRow)dg.ItemContainerGenerator.ContainerFromIndex(index);
            if (row == null)
            {
                // may be virtualized, bring into view and try again
                dg.ScrollIntoView(dg.Items[index]);
                row = (DataGridRow)dg.ItemContainerGenerator.ContainerFromIndex(index);
            }
            return row;
        }

        static T GetVisualChild<T>(Visual parent) where T : Visual
        {
            T child = default(T);
            int numVisuals = VisualTreeHelper.GetChildrenCount(parent);
            for (int i = 0; i < numVisuals; i++)
            {
                Visual v = (Visual)VisualTreeHelper.GetChild(parent, i);
                child = v as T;
                if (child == null)
                {
                    child = GetVisualChild<T>(v);
                }
                if (child != null)
                {
                    break;
                }
            }
            return child;
        }

    }
}
